# Maintaining a daily journal

Let's assume you want to write daily notes named like `2021-02-16.md` in a
`journal/daily` sub-directory. This common use case is a good fit for creating a
[note group](../config/config-group.md) overriding the default
[note creation](../notes/note-creation.md) settings.

First, create a `group` entry in the [configuration file](../config/config.md) to set the
note settings for this directory. Refer to the
[template syntax reference](../notes/template.md) to understand how to use the
`{{format-date}}` helper.

```toml
[group.daily]
# Directories listed here will automatically use this group when creating notes.
paths = ["journal/daily"]

[group.daily.note]
# %Y-%m-%d is actually the default format, so you could use {{format-date now}} instead.
filename = "{{format-date now '%Y-%m-%d'}}"
extension = "md"
template = "daily.md"
```

Next, create a template file under `.zk/templates/daily.md` to render the note
content. Here we used the date again to generate a title like "February 16,
2021".

```markdown
# {{format-date now "long"}}

What did I do today?
```

We are now ready to write today's note! We don't need to set `--title` since the
note's title is entirely generated by the template.

```sh
$ zk new journal/daily
```

That is a bit of a mouthful for a command called every day. Would it not be
better to just write `zk daily`? We can, by defining a
[command alias](../config/config-alias.md) in the [configuration file](../config/config.md).

```toml
[alias]
daily = 'zk new --no-input "$ZK_NOTEBOOK_DIR/journal/daily"'
```

Let's unpack this alias:

- `zk new` will refuse to overwrite notes. If you already created today's note,
  it will instead ask you if you wish to edit it. Using `--no-input` skips the
  prompt and edit the existing note right away.
- `$ZK_NOTEBOOK_DIR` is set to the absolute path of the current
  [notebook](../notes/notebook.md) when running an alias. Using it allows you to run
  `zk daily` no matter where you are in the notebook folder hierarchy.
- We need to use double quotes around `$ZK_NOTEBOOK_DIR`, otherwise it will not
  be expanded.

If you want to edit today's note, simply use this alias:

```sh
$ zk daily
```
