/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.wireprotocol;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.graalvm.visualvm.lib.jfluid.wireprotocol.Response;

public class GetClassFileBytesResponse
extends Response {
    private byte[][] classBytes;

    public GetClassFileBytesResponse(byte[][] bytes) {
        this();
        this.classBytes = bytes;
    }

    GetClassFileBytesResponse() {
        super(true, 15);
    }

    public byte[][] getClassBytes() {
        return this.classBytes;
    }

    public String toString() {
        return "GetClassFileBytesResponse, classes: " + this.classBytes.length + ", " + super.toString();
    }

    void readObject(ObjectInputStream in) throws IOException {
        int nClasses = in.readInt();
        if (nClasses == 0) {
            return;
        }
        this.classBytes = new byte[nClasses][];
        for (int i = 0; i < nClasses; ++i) {
            int len = in.readInt();
            if (len <= 0) continue;
            this.classBytes[i] = new byte[len];
            in.readFully(this.classBytes[i]);
        }
    }

    void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.classBytes.length);
        for (int i = 0; i < this.classBytes.length; ++i) {
            if (this.classBytes[i] == null) {
                out.writeInt(0);
                continue;
            }
            out.writeInt(this.classBytes[i].length);
            out.write(this.classBytes[i]);
        }
    }
}

