/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal.senders;

import io.jaegertracing.Configuration;
import io.jaegertracing.internal.senders.NoopSender;
import io.jaegertracing.spi.Sender;
import io.jaegertracing.spi.SenderFactory;
import java.util.Iterator;
import java.util.ServiceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SenderResolver {
    private static final Logger log = LoggerFactory.getLogger(SenderResolver.class);

    public static Sender resolve() {
        return SenderResolver.resolve(Configuration.SenderConfiguration.fromEnv());
    }

    public static Sender resolve(Configuration.SenderConfiguration senderConfiguration) {
        Sender sender = null;
        ServiceLoader<SenderFactory> senderFactoryServiceLoader = ServiceLoader.load(SenderFactory.class, SenderFactory.class.getClassLoader());
        Iterator<SenderFactory> senderFactoryIterator = senderFactoryServiceLoader.iterator();
        if (!senderFactoryIterator.hasNext()) {
            log.warn("No sender factories available. Using NoopSender, meaning that data will not be sent anywhere!");
            return new NoopSender();
        }
        String requestedFactory = System.getProperty("JAEGER_SENDER_FACTORY");
        boolean hasMultipleFactories = false;
        boolean isRequestedFactoryAvailable = false;
        while (senderFactoryIterator.hasNext()) {
            SenderFactory senderFactory = senderFactoryIterator.next();
            if (senderFactoryIterator.hasNext()) {
                log.debug("There are multiple factories available via the service loader.");
                hasMultipleFactories = true;
            }
            if (hasMultipleFactories) {
                if (!senderFactory.getType().equals(requestedFactory)) continue;
                log.debug(String.format("Found the requested (%s) sender factory: %s", requestedFactory, senderFactory));
                isRequestedFactoryAvailable = true;
                sender = SenderResolver.getSenderFromFactory(senderFactory, senderConfiguration);
                continue;
            }
            sender = SenderResolver.getSenderFromFactory(senderFactory, senderConfiguration);
        }
        if (null != sender) {
            log.debug(String.format("Using sender %s", sender));
            return sender;
        }
        if (requestedFactory == null && hasMultipleFactories) {
            log.warn("Multiple factories available but JAEGER_SENDER_FACTORY property not specified.");
        } else if (requestedFactory != null && hasMultipleFactories && !isRequestedFactoryAvailable) {
            log.warn(String.format("%s not available, using NoopSender, hence data will not be sent anywhere!", requestedFactory));
        } else {
            log.warn("No suitable sender found. Using NoopSender, meaning that data will not be sent anywhere!");
        }
        return new NoopSender();
    }

    private static Sender getSenderFromFactory(SenderFactory senderFactory, Configuration.SenderConfiguration configuration) {
        try {
            return senderFactory.getSender(configuration);
        }
        catch (Exception e) {
            log.warn("Failed to get a sender from the sender factory.", (Throwable)e);
            return null;
        }
    }
}

