/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FastLaunchStateCode {
    ENABLING("enabling"),
    ENABLING_FAILED("enabling-failed"),
    ENABLED("enabled"),
    ENABLED_FAILED("enabled-failed"),
    DISABLING("disabling"),
    DISABLING_FAILED("disabling-failed"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FastLaunchStateCode> VALUE_MAP;
    private final String value;

    private FastLaunchStateCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FastLaunchStateCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FastLaunchStateCode> knownValues() {
        EnumSet<FastLaunchStateCode> knownValues = EnumSet.allOf(FastLaunchStateCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FastLaunchStateCode.class, FastLaunchStateCode::toString);
    }
}

