/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.OperatorNotReadyException;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.general.DSAUtils;
import org.bouncycastle.crypto.general.DSTU4145Signer;
import org.bouncycastle.crypto.general.EC;
import org.bouncycastle.crypto.general.EcGost3410Signer;
import org.bouncycastle.crypto.general.Gost3410Signer;
import org.bouncycastle.crypto.internal.DSA;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class DSAOutputSigner<T extends Parameters>
implements OutputSignerUsingSecureRandom<T> {
    private final DSA dsa;
    private final Digest digest;
    private final T parameter;
    private final Initializer initializer;
    private final boolean ready;
    private final boolean reverse;

    DSAOutputSigner(DSA dSA, Digest digest, T t, Initializer initializer) {
        this(false, dSA, digest, t, initializer, false);
    }

    DSAOutputSigner(DSA dSA, Digest digest, T t, Initializer initializer, boolean bl) {
        this(false, dSA, digest, t, initializer, bl);
    }

    DSAOutputSigner(boolean bl, DSA dSA, Digest digest, T t, Initializer initializer, boolean bl2) {
        this.ready = bl;
        this.dsa = dSA;
        this.digest = digest;
        this.parameter = t;
        this.initializer = initializer;
        this.reverse = bl2;
    }

    @Override
    public T getParameters() {
        return this.parameter;
    }

    @Override
    public UpdateOutputStream getSigningStream() {
        if (!this.ready) {
            if (this.parameter.getAlgorithm().equals(EC.DDSA.getAlgorithm())) {
                this.initializer.initialize(this.dsa, null);
            } else {
                throw new OperatorNotReadyException("Signer requires a SecureRandom to be attached before use");
            }
        }
        return new DigestOutputStream(this.digest);
    }

    @Override
    public byte[] getSignature() throws PlainInputProcessingException {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        try {
            return this.encode(this.dsa.generateSignature(byArray));
        }
        catch (Exception exception) {
            throw new PlainInputProcessingException("Unable to create signature: " + exception.getMessage(), exception);
        }
    }

    @Override
    public int getSignature(byte[] byArray, int n) throws PlainInputProcessingException {
        byte[] byArray2 = this.getSignature();
        System.arraycopy(byArray2, 0, byArray, n, byArray2.length);
        return byArray2.length;
    }

    private byte[] encode(BigInteger[] bigIntegerArray) throws IOException {
        if (this.dsa instanceof EcGost3410Signer || this.dsa instanceof Gost3410Signer) {
            int n;
            byte[] byArray;
            byte[] byArray2 = bigIntegerArray[0].toByteArray();
            byte[] byArray3 = bigIntegerArray[1].toByteArray();
            if (byArray2.length > 34 || byArray3.length > 34) {
                byArray = new byte[128];
                n = 64;
            } else {
                byArray = new byte[64];
                n = 32;
            }
            if (byArray3[0] != 0) {
                System.arraycopy(byArray3, 0, byArray, n - byArray3.length, byArray3.length);
            } else {
                System.arraycopy(byArray3, 1, byArray, n - (byArray3.length - 1), byArray3.length - 1);
            }
            if (byArray2[0] != 0) {
                System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
            } else {
                System.arraycopy(byArray2, 1, byArray, byArray.length - (byArray2.length - 1), byArray2.length - 1);
            }
            return byArray;
        }
        if (this.dsa instanceof DSTU4145Signer) {
            byte[] byArray;
            byte[] byArray4 = bigIntegerArray[0].toByteArray();
            byte[] byArray5 = new byte[byArray4.length > (byArray = bigIntegerArray[1].toByteArray()).length ? byArray4.length * 2 : byArray.length * 2];
            System.arraycopy(byArray, 0, byArray5, byArray5.length / 2 - byArray.length, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray5.length - byArray4.length, byArray4.length);
            if (this.reverse) {
                DSAUtils.reverseBytes(byArray5);
            }
            return new DEROctetString(byArray5).getEncoded();
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[0]));
        aSN1EncodableVector.add(new ASN1Integer(bigIntegerArray[1]));
        return new DERSequence(aSN1EncodableVector).getEncoded("DER");
    }

    @Override
    public DSAOutputSigner<T> withSecureRandom(SecureRandom secureRandom) {
        this.initializer.initialize(this.dsa, secureRandom);
        return new DSAOutputSigner<T>(true, this.dsa, this.digest, this.parameter, this.initializer, this.reverse);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static interface Initializer {
        public void initialize(DSA var1, SecureRandom var2);
    }
}

