/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter computes one-pixel-wide edges of the input image.


This class is parameterized over the type of the input image and the
type of the output image.

The input is assumed to be a binary image. If the foreground pixels of
the input image do not have a value of 1, they are rescaled to 1
internally to simplify the computation.

The filter will produce a skeleton of the object. The output
background values are 0, and the foreground values are 1.

This filter is a sequential thinning algorithm and known to be
computational time dependable on the image size. The algorithm
corresponds with the 2D implementation described in:

Rafael C. Gonzales and Richard E. Woods. Digital Image Processing. Addison Wesley, 491-494, (1993).

To do: Make this filter ND.


See:
 MorphologyImageFilter

 itk::simple::BinaryThinning for the procedural interface

 itk::BinaryThinningImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkBinaryThinningImageFilter.h
*/
public class BinaryThinningImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected BinaryThinningImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BinaryThinningImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BinaryThinningImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BinaryThinningImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::BinaryThinningImageFilter::~BinaryThinningImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BinaryThinningImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BinaryThinningImageFilter::BinaryThinningImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BinaryThinningImageFilter() {
    this(SimpleITKJNI.new_BinaryThinningImageFilter(), true);
  }

  /**
std::string itk::simple::BinaryThinningImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BinaryThinningImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BinaryThinningImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BinaryThinningImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::BinaryThinningImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.BinaryThinningImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
