/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorFloat
extends AbstractList<Float>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorFloat(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorFloat vectorFloat) {
        return vectorFloat == null ? 0L : vectorFloat.swigCPtr;
    }

    protected static long swigRelease(VectorFloat vectorFloat) {
        long l = 0L;
        if (vectorFloat != null) {
            if (!vectorFloat.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorFloat.swigCPtr;
            vectorFloat.swigCMemOwn = false;
            vectorFloat.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorFloat(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorFloat(float[] fArray) {
        this();
        this.reserve(fArray.length);
        for (float f : fArray) {
            this.add(Float.valueOf(f));
        }
    }

    public VectorFloat(Iterable<Float> iterable) {
        this();
        for (float f : iterable) {
            this.add(Float.valueOf(f));
        }
    }

    @Override
    public Float get(int n) {
        return Float.valueOf(this.doGet(n));
    }

    @Override
    public Float set(int n, Float f) {
        return Float.valueOf(this.doSet(n, f.floatValue()));
    }

    @Override
    public boolean add(Float f) {
        ++this.modCount;
        this.doAdd(f.floatValue());
        return true;
    }

    @Override
    public void add(int n, Float f) {
        ++this.modCount;
        this.doAdd(n, f.floatValue());
    }

    @Override
    public Float remove(int n) {
        ++this.modCount;
        return Float.valueOf(this.doRemove(n));
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorFloat() {
        this(SimpleITKJNI.new_VectorFloat__SWIG_0(), true);
    }

    public VectorFloat(VectorFloat vectorFloat) {
        this(SimpleITKJNI.new_VectorFloat__SWIG_1(VectorFloat.getCPtr(vectorFloat), vectorFloat), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorFloat_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorFloat_clear(this.swigCPtr, this);
    }

    public VectorFloat(int n, float f) {
        this(SimpleITKJNI.new_VectorFloat__SWIG_2(n, f), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorFloat_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorFloat_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorFloat_doSize(this.swigCPtr, this);
    }

    private void doAdd(float f) {
        SimpleITKJNI.VectorFloat_doAdd__SWIG_0(this.swigCPtr, this, f);
    }

    private void doAdd(int n, float f) {
        SimpleITKJNI.VectorFloat_doAdd__SWIG_1(this.swigCPtr, this, n, f);
    }

    private float doRemove(int n) {
        return SimpleITKJNI.VectorFloat_doRemove(this.swigCPtr, this, n);
    }

    private float doGet(int n) {
        return SimpleITKJNI.VectorFloat_doGet(this.swigCPtr, this, n);
    }

    private float doSet(int n, float f) {
        return SimpleITKJNI.VectorFloat_doSet(this.swigCPtr, this, n, f);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorFloat_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

